class TeamspeakInfo expands ReplicationInfo;

// ---------------------------------------------------------------------------------
// TeamSpeak Mutator v03c
// ---------------------------------------------------------------------------------
// Enables a player to connect to a teamspeak server ingame using the commands:
// "mutate teamspeak" to connect to their respective team-subchannel
// "mutate tsb" to connect to the blueteam-subchannel
// "mutate tsr" to connect to the redteam-subchannel
// "mutate tst" to connect to the together-subchannel
// "mutate tss" to connect to the spectator-subchannel
// "mutate tch channelname" to connect to the channel "channelname"
//
// Bugs:
// - When you are allready connected to the server, and enter unreal and use the mutator
//   to enter a channel and it fails, you have to type the mutator command again. 
//   This is because the first time it tries to connect it uses the password to connect.
//   After that it doesn't send the serverpassword anymore, see changes in v3c.
// - When using a password on the channel, you can only connect to the given channel
//   the first time. After that, it doesn't work anymore due to a bug in the TS client.
// 
//   I've informed the TS devs about these bugs, i hope they fix it soon.. 
//
//
// Changes by smaankerezz in v3c
// - the server password is only send to the teamspeak client the first time instead of 
//   each time a player connects. This is due to a bug in TS. 
// - fixed the error in the teamspeak.ini

// Changes by smaankerezz in v3b
// - settings from the ini file are properly loaded, thnx rednas :)
// - two configurable welcome messages depending on whether or not bEnableCommands 
//   is set to true.
//
// Changes by smaankerezz since v2 by rednas & idefix:
// - a player can also connect to a channel of their own choice using tch
// - shows the player to which server, channel and subchannel it is connecting
// - added the playername characters {}<>`+| also to be changed into "" 
// - changed the channeling a bit 
//
// ---------------------------------------------------------------------------------

var string sURL;			// Replicated

replication
{
	reliable if ( ROLE == ROLE_Authority)
		sURL, StartTS;
}

simulated function StartTS(string sServerInfo, string sChannelInfo, string sSubChannelInfo)
{
	local PlayerPawn pp;

	if (Owner!=None)
	{
		pp = PlayerPawn(Owner);
		if (pp!=None && pp.Player!=None && pp.Player.Console !=None)
		{
			pp.ClientMessage(">> Connecting to teamspeak..");
			
			pp.ClientMessage(sServerInfo);
			pp.ClientMessage(sChannelInfo);
			if (sSubChannelInfo != "") {
				pp.ClientMessage(sSubChannelInfo);
			}

			pp.ConsoleCommand("START " $ sURL);
		}
	}

	Destroy();
}

defaultproperties
{
}
